/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import net.minecraft.client.Minecraft;
import noppes.npcs.client.model.part.ModelEyeData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.util.ValueUtil;

public class EyeRenderData {
    private final boolean isLeft;
    private boolean isUpdate = false;
    public boolean isShow = true;
    public final float[] eyeColor = new float[]{1.0f, 1.0f, 1.0f};
    public float eyePosX = 0.0f;
    public float eyePosY = 0.0f;
    public float eyeScaleX = 1.0f;
    public float eyeScaleY = 1.0f;
    public float eyeWeight = 2.0f;
    public float eyeHeight = 1.0f;
    public float eyeHoverY;
    public final float[] pupilColor = new float[]{1.0f, 1.0f, 1.0f};
    public double pupilLeft;
    public double pupilTop;
    public double pupilRight;
    public double pupilBottom;
    public double pupilX;
    public double pupilY;
    public double pupilScaleX;
    public double pupilScaleY;
    public double centerLeft;
    public double centerTop;
    public double centerRight;
    public double centerBottom;
    public boolean glintShow = true;
    public float glintAlpha = 1.0f;
    public int glintColor = -1;
    public double glintLeft = -0.1;
    public double glintRight = 0.1;
    public double glintTop = -0.1;
    public double glintBottom = 0.1;

    public EyeRenderData(boolean isLeftIn) {
        this.isLeft = isLeftIn;
    }

    public void update(EntityCustomNpc npc, ModelEyeData eyes, int closedType, float[] data, Float[] eyeData, Float[] pupilData, boolean isDisableMoved) {
        boolean bl = this.isShow = eyes.closed != 1 && eyes.closed != closedType && eyes.pattern != 1 && npc.func_70089_S() && !npc.func_70608_bn();
        if (!this.isShow) {
            return;
        }
        if (this.isUpdate) {
            return;
        }
        this.isUpdate = true;
        float f = this.eyePosX = this.isLeft ? 1.0f : -1.0f;
        if (eyes.type == 2 && !this.isLeft) {
            this.eyePosX -= 2.0f;
        }
        this.eyePosY = -5.0f + data[0];
        this.eyeScaleX = 1.0f;
        this.eyeScaleY = 1.0f;
        if (eyeData != null && !isDisableMoved) {
            this.eyePosX += eyeData[0].floatValue();
            this.eyePosY += eyeData[1].floatValue();
            this.eyeScaleX = eyeData[2].floatValue();
            this.eyeScaleY = eyeData[3].floatValue();
        }
        this.eyeWeight = this.isLeft ? 2.0f : -2.0f;
        this.eyeHeight = 1.0f + data[1] - data[0];
        this.eyeHoverY = data[1] - data[0];
        if (eyes.type == 2) {
            this.eyeColor[0] = (float)(eyes.eyeColor[1] >> 16 & 0xFF) / 127.5f;
            this.eyeColor[1] = (float)(eyes.eyeColor[1] >> 8 & 0xFF) / 127.5f;
            this.eyeColor[2] = (float)(eyes.eyeColor[1] & 0xFF) / 127.5f;
        }
        this.pupilScaleX = 1.0;
        this.pupilScaleY = 1.0;
        if (pupilData != null && !isDisableMoved) {
            this.pupilScaleX = pupilData[2].floatValue();
            this.pupilScaleY = pupilData[3].floatValue();
        }
        float x = data[4];
        float y = data[5];
        if (this.isLeft && !eyes.activeLeft || !this.isLeft && !eyes.activeRight || isDisableMoved) {
            x = 0.0f;
            y = 0.0f;
        }
        this.pupilLeft = -0.5;
        this.pupilRight = 0.5;
        double ySize = eyes.type == 1 ? (double)0.85f : 0.5;
        this.pupilTop = -ySize;
        this.pupilBottom = ySize;
        if (eyes.type == 2) {
            this.pupilColor[0] = (float)(eyes.pupilColor[1] >> 16 & 0xFF) / 127.5f;
            this.pupilColor[1] = (float)(eyes.pupilColor[1] >> 8 & 0xFF) / 127.5f;
            this.pupilColor[2] = (float)(eyes.pupilColor[1] & 0xFF) / 127.5f;
            this.pupilX = 0.0;
            this.pupilY = 0.0;
            if ((double)x != 0.0 || (double)y != 0.0) {
                double maxRadiusSquare = 1.0;
                double ellipseMajorAxis = 0.45;
                double ellipseMinorAxis = 0.3;
                double radiusSquare = ValueUtil.correctDouble(Math.hypot(x, y), -1.0, 1.0);
                double angleTheta = Math.atan2(y, x);
                double numerator = ellipseMajorAxis * ellipseMinorAxis;
                double denominator = Math.sqrt(Math.pow(ellipseMinorAxis, 2.0) * Math.cos(angleTheta) * Math.cos(angleTheta) + Math.pow(ellipseMajorAxis, 2.0) * Math.sin(angleTheta) * Math.sin(angleTheta));
                double radiusEllipse = numerator / denominator;
                double correctedRadius = radiusEllipse * radiusSquare / maxRadiusSquare;
                this.pupilX = correctedRadius * Math.cos(angleTheta);
                this.pupilY = correctedRadius * Math.sin(angleTheta);
            }
        } else {
            double start;
            this.pupilX = (this.isLeft ? 1.0 : -1.0) + (double)x;
            double d = !this.isLeft ? 2.0 : 0.0;
            if (this.pupilX <= 0.5 * this.pupilScaleX - d) {
                this.pupilLeft = this.isLeft ? this.pupilX / -this.pupilScaleX : (2.0 + this.pupilX) / -this.pupilScaleX;
            }
            if ((double)x > 1.0 - 0.5 * this.pupilScaleX) {
                this.pupilRight = this.isLeft ? (2.0 - this.pupilX) / this.pupilScaleX : this.pupilX / -this.pupilScaleX;
            }
            this.pupilY = eyes.type == 1 ? 0.85 + (double)y : 0.5 + (double)y / 2.0;
            if (this.pupilY < ySize * this.pupilScaleY) {
                this.pupilTop = this.pupilY / -this.pupilScaleY;
            }
            if (this.pupilY > (start = ySize - ySize * (this.pupilScaleY - 1.0))) {
                double e0 = (eyes.type == 1 ? ySize - 1.0 : ySize - 0.5) / this.pupilScaleY;
                double e1 = eyes.type == 1 ? ySize + 1.0 : ySize + 0.5;
                double a = (ySize - e0) / (start - e1);
                double b = ySize - a * start;
                this.pupilBottom = a * this.pupilY + b;
            }
        }
        double size = 0.2;
        this.centerLeft = -size;
        this.centerTop = -size;
        this.centerRight = size;
        this.centerBottom = size;
        if (this.centerLeft < this.pupilLeft) {
            this.centerLeft = this.pupilLeft;
        }
        if (this.centerRight > this.pupilRight) {
            this.centerRight = this.pupilRight;
        }
        if (this.centerTop < this.pupilTop) {
            this.centerTop = this.pupilTop;
        }
        if (this.centerBottom > this.pupilBottom) {
            this.centerBottom = this.pupilBottom;
        }
        if (eyes.glint) {
            Minecraft mc = Minecraft.func_71410_x();
            this.glintShow = false;
            this.glintAlpha = 1.0f;
            x = data[6];
            y = data[7];
            if (mc.field_71441_e != null) {
                long time = mc.field_71441_e.func_72820_D();
                float npcRot = npc.field_70759_as % 360.0f;
                if (npcRot < 0.0f) {
                    npcRot += 360.0f;
                }
                float height = 0.65f * (float)ySize;
                if (time <= 23200L && time > 12800L) {
                    float lightYaw = Math.round(-0.017308f * (float)time + 491.53845f);
                    this.glintAlpha = -0.096154f * Math.abs((float)time - 18000.0f) / 1000.0f + 1.0f;
                    if (time >= 18000L) {
                        boolean bl2 = this.glintShow = time < 21000L || npcRot >= 30.0f && npcRot <= 150.0f;
                        if (this.glintShow) {
                            if (npcRot >= 210.0f && npcRot <= 330.0f) {
                                x = ValueUtil.correctFloat(0.005417f * npcRot - 0.4875f, -height, height);
                                y = ValueUtil.correctFloat(-0.003611f * lightYaw + height, -height, 0.0f);
                            } else {
                                x = 0.0f;
                                y = -height;
                            }
                        }
                    } else {
                        boolean bl3 = this.glintShow = time > 15200L || npcRot >= 210.0f && npcRot <= 330.0f;
                        if (this.glintShow) {
                            if (npcRot >= 210.0f && npcRot <= 330.0f) {
                                x = ValueUtil.correctFloat(0.005417f * npcRot - 1.4625f, -height, height);
                                y = ValueUtil.correctFloat(0.003611f * (lightYaw - 180.0f) - height, -height, 0.0f);
                            } else {
                                x = 0.0f;
                                y = -height;
                            }
                        }
                    }
                } else if (time >= 6000L && time < 12800L) {
                    this.glintAlpha = -0.073529f * Math.abs((float)time - 6000.0f) / 1000.0f + 1.0f;
                    float lightYaw = Math.round(-0.013235f * (float)time + 259.41177f);
                    boolean bl4 = this.glintShow = time < 9000L || npcRot >= 30.0f && npcRot <= 150.0f;
                    if (this.glintShow) {
                        if (npcRot >= 30.0f && npcRot <= 150.0f) {
                            x = ValueUtil.correctFloat(0.005417f * npcRot - 0.4875f, -height, height);
                            y = ValueUtil.correctFloat(-0.003611f * lightYaw + height, -height, 0.0f);
                        } else {
                            x = 0.0f;
                            y = -height;
                        }
                    }
                } else {
                    time = time > 23200L ? (time -= 23200L) : (time += 800L);
                    this.glintAlpha = -0.073529f * Math.abs((float)time - 6800.0f) / 1000.0f + 1.0f;
                    float lightYaw = Math.round(-0.013237f * (float)time + 270.0f);
                    boolean bl5 = this.glintShow = time > 6000L || npcRot >= 210.0f && npcRot <= 330.0f;
                    if (this.glintShow) {
                        if (npcRot >= 210.0f && npcRot <= 330.0f) {
                            x = ValueUtil.correctFloat(0.005417f * npcRot - 1.4625f, -height, height);
                            y = ValueUtil.correctFloat(0.003611f * (lightYaw - 180.0f) - height, -height, 0.0f);
                        } else {
                            x = 0.0f;
                            y = -height;
                        }
                    }
                }
            }
            this.glintLeft = -0.1 + (double)x;
            this.glintRight = 0.1 + (double)x;
            this.glintTop = -0.1 + (double)y;
            this.glintBottom = 0.1 + (double)y;
            if (this.glintLeft < this.pupilLeft) {
                this.glintLeft = this.pupilLeft;
            }
            if (this.glintRight > this.pupilRight) {
                this.glintRight = this.pupilRight;
            }
            if (this.glintTop < this.pupilTop) {
                this.glintTop = this.pupilTop;
            }
            if (this.glintBottom > this.pupilBottom) {
                this.glintBottom = this.pupilBottom;
            }
            if (this.glintLeft > this.glintRight || this.glintLeft == this.glintRight) {
                this.glintShow = false;
            }
            if (this.glintTop > this.glintBottom || this.glintTop == this.glintBottom) {
                this.glintShow = false;
            }
            if (this.glintShow) {
                if (eyes.type != 2) {
                    this.glintColor = 0xFFFFFF | (int)Math.ceil(this.glintAlpha * 255.0f) << 24;
                }
            } else if (eyes.type == 2) {
                this.glintShow = true;
            }
        }
        this.isUpdate = false;
    }
}

